// TouchInputDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "TouchInputDlg.h"
#include "IBFlowView.h"
#include "XISLVarDlg.h"
#include "XISLChangeVarDlg.h"
#include "XISLVarList.h"
#include "XISLVar.h"
#include "XISLTouchInputTag.h"
#include "XISLDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CTouchInputDlg _CAO


CTouchInputDlg::CTouchInputDlg(CXISLTouchInputTag *pTag,CXISLTag *pCurrentTag,BOOL bNew,CWnd* pParent /*=NULL*/)
	: CDialog(CTouchInputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTouchInputDlg)
	m_nEventGlp = 0;
	m_bPointCheck = FALSE;
	m_bAttrCheck = FALSE;
	m_strX = _T("");
	m_strY = _T("");
	m_strAttrVar = _T("");
	m_strMatch = _T("");
	//}}AFX_DATA_INIT
	m_pParent = pParent;
	m_pInputTag = pTag;
	m_pCurrentTag = pCurrentTag;
	m_bNew = bNew;
	m_pAttrVar = NULL;
	m_pXVar = NULL;
	m_pYVar = NULL;
	Create(CTouchInputDlg::IDD,pParent);
}


void CTouchInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTouchInputDlg)
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Radio(pDX, IDC_TOUCH_CLICK_RADIO, m_nEventGlp);
	DDX_Check(pDX, IDC_TOUCH_POINT_CHECK, m_bPointCheck);
	DDX_Check(pDX, IDC_TOUCH_ATTR_CHECK, m_bAttrCheck);
	DDX_Text(pDX, IDC_EDIT_POINTX, m_strX);
	DDX_Text(pDX, IDC_EDIT_POINTY, m_strY);
	DDX_Text(pDX, IDC_EDIT_ATTRVAR, m_strAttrVar);
	DDX_Text(pDX, IDC_TOUCH_MATCH_EDIT, m_strMatch);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTouchInputDlg, CDialog)
	//{{AFX_MSG_MAP(CTouchInputDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_CHANGE, OnButtonChange)
	ON_BN_CLICKED(IDC_BUTTON_NEWVAR, OnButtonNewvar)
	ON_EN_SETFOCUS(IDC_EDIT_ATTRVAR, OnSetfocusEditAttrvar)
	ON_EN_SETFOCUS(IDC_EDIT_POINTX, OnSetfocusEditPointx)
	ON_EN_SETFOCUS(IDC_EDIT_POINTY, OnSetfocusEditPointy)
	ON_BN_CLICKED(IDC_TOUCH_ATTR_CHECK, OnTouchAttrCheck)
	ON_BN_CLICKED(IDC_TOUCH_POINT_CHECK, OnTouchPointCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CTouchInputDlg::SetMatch(LPCTSTR lpszMatch)
{
	UpdateData();
	m_strMatch = lpszMatch;
	GetDlgItem(IDC_TOUCH_POINT_CHECK)->EnableWindow(TRUE);
	GetDlgItem(IDC_TOUCH_ATTR_CHECK)->EnableWindow(TRUE);
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CTouchInputDlg bZ[W nh

void CTouchInputDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	m_pInputTag->SetAttribute(m_nEventGlp,m_strMatch,m_pAttrVar,m_pXVar,m_pYVar);

	if(m_bNew)
	{
		if(m_pParent->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
			((CIBFlowView*)m_pParent)->InsertInputTouch();
	}
	else
	{
		CXISLDoc *pDoc = (CXISLDoc*)((CIBFlowView*)m_pParent)->GetDocument();
		pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
		DestroyWindow();
	}
}

void CTouchInputDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(m_pParent->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
	{
		((CIBFlowView*)m_pParent)->m_bDropOK = TRUE;
		((CIBFlowView*)m_pParent)->m_pTIDlg = NULL;
	}

	delete this;
//	CDialog::PostNcDestroy();
}

void CTouchInputDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_bNew)
	{
		delete m_pInputTag;
		m_pInputTag = NULL;
	}
	else
	{
		if(m_pInputTag->m_pAttrVar)
			m_pInputTag->m_pAttrVar->ReferCount(TRUE);
		if(m_pInputTag->m_pXVar)
			m_pInputTag->m_pXVar->ReferCount(TRUE);
		if(m_pInputTag->m_pYVar)
			m_pInputTag->m_pYVar->ReferCount(TRUE);
	}

	((CIBFlowView*)m_pParent)->ResetViewItem();
	DestroyWindow();
//	CDialog::OnCancel();
}

BOOL CTouchInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_nEventGlp = m_pInputTag->GetEvent();
	m_strMatch = m_pInputTag->GetMatch();
	if(m_strMatch.IsEmpty())
	{
		GetDlgItem(IDC_TOUCH_POINT_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_TOUCH_ATTR_CHECK)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_POINTX)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_POINTY)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_ATTRVAR)->EnableWindow(FALSE);
	}
	else
	{
		if(m_pInputTag->m_pAttrVar)
		{
			m_pAttrVar = m_pInputTag->m_pAttrVar;
			m_bAttrCheck = TRUE;
			m_pAttrVar->GetVarNameEx(m_strAttrVar);
			int nStart = m_strMatch.Find(m_strAttrVar);
			int nEnd = m_strMatch.Find(":=",nStart)+2;
			m_strMatch.Delete(nStart,nEnd-nStart);

			m_pAttrVar->ReferCount(FALSE);
		}
		if(m_pInputTag->m_pXVar && m_pInputTag->m_pYVar)
		{
			m_bPointCheck = TRUE;
			m_pXVar = m_pInputTag->m_pXVar;
			m_pXVar->GetVarNameEx(m_strX);
			m_pInputTag->m_pXVar->ReferCount(FALSE);
			m_pYVar = m_pInputTag->m_pYVar;
			m_pYVar->GetVarNameEx(m_strY);
			m_pInputTag->m_pYVar->ReferCount(FALSE);
		}
	}

	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 50;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-50;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	if(nType == ID_TAG_EXCHANGE || nType == ID_TAG_BEGIN || nType == ID_TAG_END
		|| nType == ID_TAG_PINPUT || nType == ID_TAG_AINPUT || nType == ID_TAG_SINPUT)
	{
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
		int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
		CXISLDialogTag *pDTag = (CXISLDialogTag*)pExcItem->GetParentDialogTag();
		nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	}
	else
		ASSERT(NULL);

	m_brEdit.CreateSolidBrush(RGB(255,255,255));

	UpdateData(FALSE);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CTouchInputDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		switch(m_nActive)
		{
		case IDC_EDIT_POINTX:
			if(m_bPointCheck)
			{
				m_pXVar = (CXISLVar*)item.lParam;
				m_pXVar->GetVarNameEx(m_strX);
			}
			break;
		case IDC_EDIT_POINTY:
			if(m_bPointCheck)
			{
				m_pYVar = (CXISLVar*)item.lParam;
				m_pYVar->GetVarNameEx(m_strY);
			}
			break;
		case IDC_EDIT_ATTRVAR:
			if(m_bAttrCheck)
			{
				m_pAttrVar = (CXISLVar*)item.lParam;
				m_pAttrVar->GetVarNameEx(m_strAttrVar);
			}
			break;
		}
		UpdateData(FALSE);
	}
	*pResult = 0;
}

HBRUSH CTouchInputDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	int nCtrlID = pWnd->GetDlgCtrlID();
	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		if(nCtrlID == IDC_EDIT_POINTX||nCtrlID == IDC_EDIT_POINTY
			||nCtrlID == IDC_EDIT_ATTRVAR||nCtrlID == IDC_TOUCH_MATCH_EDIT)
		{
			pDC->SetBkMode(TRANSPARENT);	// wi
			pDC->SetTextColor(RGB(0,0,0));	// eLXgFݒ
			return (HBRUSH) m_brEdit;		// _~[uV
		}
	default:
		break;
	}

	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}

void CTouchInputDlg::OnButtonChange() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nIndex;
	POSITION pos = m_lbVar.GetFirstSelectedItemPosition();
	if(pos == NULL)
		return;
	nIndex = m_lbVar.GetNextSelectedItem(pos);
	
	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = nIndex;
	item.iSubItem = 0;
    item.pszText = szBuff;
    item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	CXISLVar *pVar = (CXISLVar*)item.lParam;
	CXISLChangeVarDlg CVarDlg(pVar);
	if(CVarDlg.DoModal() != IDOK)
		return;	
}

void CTouchInputDlg::OnButtonNewvar() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CXISLVarDlg VarDlg(m_pCurrentTag);
	if(VarDlg.DoModal() != IDOK)
		return;

	m_lbVar.DeleteAllItems();
	int nType = m_pCurrentTag->m_nTagType;
	if(nType == ID_TAG_EXCHANGE	|| nType == ID_TAG_PINPUT || nType == ID_TAG_AINPUT || nType == ID_TAG_SINPUT)
	{
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
		int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
		nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	}	
}

BOOL CTouchInputDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CXISLVar *pVar=NULL;
        if(pMsg->wParam == VK_RETURN)
			return TRUE;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CTouchInputDlg::OnSetfocusEditAttrvar() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_nActive = IDC_EDIT_ATTRVAR;
}

void CTouchInputDlg::OnSetfocusEditPointx() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_nActive = IDC_EDIT_POINTX;
}

void CTouchInputDlg::OnSetfocusEditPointy() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_nActive = IDC_EDIT_POINTY;
}


void CTouchInputDlg::OnTouchAttrCheck() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_bAttrCheck)
		GetDlgItem(IDC_EDIT_ATTRVAR)->EnableWindow(TRUE);
	else
	{
		GetDlgItem(IDC_EDIT_ATTRVAR)->EnableWindow(FALSE);
		m_pAttrVar = NULL;
		m_strAttrVar.Empty();
	}
	UpdateData(FALSE);
}

void CTouchInputDlg::OnTouchPointCheck() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_bPointCheck)
	{
		GetDlgItem(IDC_EDIT_POINTX)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_POINTY)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_POINTX)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_POINTY)->EnableWindow(FALSE);
		m_pXVar = NULL; m_pYVar = NULL;
		m_strX.Empty(); m_strY.Empty();
	}
	UpdateData(FALSE);
}
